﻿//=============================================================================
// TMPlugin - コモンコマンド (RPGツクールMZ版)
// バージョン: 1.1.0
// 最終更新日: 2024/12/27
// 配布元　　: https://hikimoki.sakura.ne.jp/
//-----------------------------------------------------------------------------
// Copyright (c) 2018 tomoaky
// Released under the MIT license.
// http://opensource.org/licenses/mit-license.php
//=============================================================================

/*:
 * @target MZ
 * @plugindesc メインメニューにコモンイベント実行用のコマンドを追加します。
 *
 * @author tomoaky 改変：ユースフル小屋
 *
 * @param command1
 * @text コマンド1
 * @type struct<CommonCommand>
 * @desc コモンコマンドその１
 * @default {"name":"","commonEventId":"0"}
 * 
 * @param command2
 * @text コマンド2
 * @type struct<CommonCommand>
 * @desc コモンコマンドその２
 * @default {"name":"","commonEventId":"0"}
 * 
 * @param command3
 * @text コマンド3
 * @type struct<CommonCommand>
 * @desc コモンコマンドその３
 * @default {"name":"","commonEventId":"0"}
 * 
 * @param command4
 * @text コマンド4
 * @type struct<CommonCommand>
 * @desc コモンコマンドその４
 * @default {"name":"","commonEventId":"0"}
 * 
 * @param command5
 * @text コマンド5
 * @type struct<CommonCommand>
 * @desc コモンコマンドその５
 * @default {"name":"","commonEventId":"0"}
 * 
 * @help
 * TMPlugin - コモンコマンド ver1.1.0 (MZ対応版)
 * 
 * 使い方:
 * 
 *   プラグインパラメータのコマンド名と実行するコモンイベントを設定すれば
 *   メインメニューに新しいコマンドが追加されます。
 * 
 *   このプラグインは RPGツクールMZ で動作確認をしています。
 *
 *   このプラグインはMITライセンスのもとに配布しています、商用利用、
 *   改造、再配布など、自由にお使いいただけます。
 */

/*~struct~CommonCommand:
 *
 * @param name
 * @text コマンド名
 * @desc メニューに表示されるコマンド名
 * @default 
 *
 * @param commonEventId
 * @text コモンイベントID
 * @type common_event
 * @desc 実行するコモンイベント
 * @default 0
 *
 */

(() => {
    'use strict';

    const pluginName = 'TMCommonCommand';
    const parameters = PluginManager.parameters(pluginName);
    
    // パラメータの解析
    const CommonCommands = [];
    for (let i = 1; i <= 5; i++) {
        const commandParam = parameters['command' + i];
        if (commandParam) {
            try {
                const parsed = JSON.parse(commandParam);
                CommonCommands.push({
                    name: parsed.name || '',
                    commonEventId: Number(parsed.commonEventId) || 0
                });
            } catch (e) {
                CommonCommands.push({ name: '', commonEventId: 0 });
            }
        } else {
            CommonCommands.push({ name: '', commonEventId: 0 });
        }
    }

    //-----------------------------------------------------------------------------
    // Window_MenuCommand
    //

    const _Window_MenuCommand_addOriginalCommands = Window_MenuCommand.prototype.addOriginalCommands;
    Window_MenuCommand.prototype.addOriginalCommands = function() {
        _Window_MenuCommand_addOriginalCommands.call(this);
        for (const command of CommonCommands) {
            if (command.commonEventId > 0 && command.name) {
                this.addCommand(command.name, 'commonCommand_' + command.name, true);
            }
        }
    };

    //-----------------------------------------------------------------------------
    // Scene_Menu
    //

    const _Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
    Scene_Menu.prototype.createCommandWindow = function() {
        _Scene_Menu_createCommandWindow.call(this);
        for (const command of CommonCommands) {
            if (command.commonEventId > 0 && command.name) {
                this._commandWindow.setHandler('commonCommand_' + command.name, 
                    this.commandCommonCommand.bind(this, command));
            }
        }
    };

    Scene_Menu.prototype.commandCommonCommand = function(command) {
        $gameTemp.reserveCommonEvent(command.commonEventId);
        if ($gameTemp.isCommonEventReserved()) {
            SceneManager.goto(Scene_Map);
        } else {
            this._commandWindow.activate();
        }
    };

})();